﻿Public Class frmMain

    Private lDownloadCount As Long           ''JVOpen:総ダウロードファイル数
    Private JVOpenFlg As Boolean            ''JVOpen状態フラグ Opne時:Ture
    Private objCodeConv As Object            ''コード変換インスタンス

    Private Sub mnuConfJV_Click(sender As Object, e As EventArgs) Handles mnuConfJV.Click
        Try
            ' リターンコード
            Dim lReturnCode As Long
            ' 設定画面表示
            lReturnCode = Class1.AxJVLink.JVSetUIProperties()
            If lReturnCode <> 0 Then
                MsgBox("JVSetUIPropertiesエラー コード：" & lReturnCode & "：", MessageBoxIcon.Error)
            End If
        Catch ex As Exception
        End Try

    End Sub

    Private Sub frmMain_Load(sender As Object, e As EventArgs) Handles Me.Load
        Dim sid As String
        Dim lReturnCode As Long

        '引数設定
        sid = "Test"

        'JVLink初期化
        lReturnCode = Class1.AxJVLink.JVInit(sid)

        'エラー判定
        If lReturnCode <> 0 Then
            MsgBox("JVInitエラー コード：" & lReturnCode & "：", MessageBoxIcon.Error)
            Me.Cursor = System.Windows.Forms.Cursors.Default
            Exit Sub
        End If
        'コード変換インスタンス生成
        objCodeConv = New clsCodeConv
        'パスを指定し、コードファイルを読込む
        objCodeConv.FileName = Application.StartupPath & "\CodeTable.csv"

    End Sub

    Private Sub btnGetJVData_Click(sender As Object, e As EventArgs) Handles btnGetJVData.Click
        Dim lReturnCode As Long

        Try
            Dim strDataSpec As String        '' 引数 JVOpen:ファイル識別子
            Dim strFromTime As String        '' 引数 JVOpen:データ提供日付
            Dim lOption As Long              '' 引数 JVOpen:オプション
            Dim lReadCount As Long           '' JVLink 戻り値
            Dim lDownloadCount As Long       '' JVOpen:総ダウンロードファイル数
            Dim strLastFileTimestamp As String '' JVOpen: 最新ファイルのタイムスタンプﾟ

            Const lBuffSize As Long = 110000  ''JVRead:データ格納バッファサイズ
            Const lNameSize As Integer = 256  ''JVRead:ファイル名サイズ
            Dim strBuff As String             ''JVRead:データ格納バッファ
            Dim strFileName As String         ''JVRead:ダウンロードファイル名
            Dim RaceInfo As JV_RA_RACE        ''レース詳細情報構造体

            '進捗表示初期設定
            tmrDownload.Enabled = False       ''タイマー停止
            prgDownload.Value = 0             ''JVDataダウンロード進捗
            prgJVRead.Value = 0               ''JVData読み込み進捗

            '引数設定
            strDataSpec = "RACE"
            strFromTime = "20050301000000"
            lOption = "2"

            'JVLinkダウンロード処理
            lReturnCode = Class1.AxJVLink.JVOpen(strDataSpec, strFromTime, lOption,
                        lReadCount, lDownloadCount, strLastFileTimestamp)

            'エラー判定
            If lReturnCode <> 0 Then
                MsgBox("JVOpenエラー：" & lReturnCode)
            Else
                MsgBox("戻り値 : " & lReturnCode & vbCrLf &
               "読み込みファイル数 : " & lReadCount & vbCrLf &
               "ダウンロードファイル数 : " & lDownloadCount & vbCrLf &
               "タイムスタンプ : " & strLastFileTimestamp)

                '進捗表示プログレスバー最大値設定
                If lDownloadCount = 0 Then
                    prgDownload.Maximum = 100           ''ダウンロード必要無し
                    prgDownload.Value = 100
                Else
                    prgDownload.Maximum = lDownloadCount
                    tmrDownload.Enabled = True          ''タイマー開始
                End If
                prgJVRead.Maximum = lReadCount

                If lReadCount > 0 Then
                    Do
                        'バックグラウンドでの処理を実行
                        Application.DoEvents()

                        'バッファ作成
                        strBuff = New String(vbNullChar, lBuffSize)
                        strFileName = New String(vbNullChar, lNameSize)

                        'JVReadで１行読み込み
                        lReturnCode = Class1.AxJVLink.JVRead(strBuff, lBuffSize,
 strFileName)

                        'リターンコードにより処理を分枝
                        Select Case lReturnCode
                            Case 0      ' 全ファイル読み込み終了
                                prgJVRead.Value = prgJVRead.Maximum   '進捗表示
                                Exit Do
                            Case -1 ' ファイル切り替わり
                            Case -3     ' ダウンロード中
                            Case -201   ' Initされてない
                                MsgBox("JVInitが行われていません。")
                                Exit Do
                            Case -203   ' Openされてない
                                MsgBox("JVOpenが行われていません。")
                                Exit Do
                            Case -503   ' ファイルがない
                                MsgBox(strFileName & "が存在しません。")
                                Exit Do
                            Case Is > 0 ' 正常読み込み
                                'レコード種別IDの識別
                                If Mid(strBuff, 1, 2) = "RA" Then
                                    'レース詳細のみ処理
                                    'レース詳細構造体への展開
                                    RaceInfo.SetData(strBuff)

                                    'データ表示
                                    rtbData.AppendText(
                                   "年:" & RaceInfo.id.Year &
                                   " 月日:" & RaceInfo.id.MonthDay &
               " 場:" & objCodeConv.GetCodeName("2001", RaceInfo.id.JyoCD, "3") &
                                   " 回次:" & RaceInfo.id.Kaiji &
                                   " 日次:" & RaceInfo.id.Nichiji &
                                   " Ｒ:" & RaceInfo.id.RaceNum &
                                   " レース名:" & RaceInfo.RaceInfo.Ryakusyo10 & vbCrLf)
                                Else
                                    'レース詳細以外は読み飛ばす
                                    Call Class1.AxJVLink.JVSkip()
                                End If
                        End Select
                    Loop While (1)
                End If
                'タイマ有効時は、無効化する
                If tmrDownload.Enabled = True Then
                    tmrDownload.Enabled = False
                    prgDownload.Value = prgDownload.Maximum
                End If

            End If

        Catch
            Debug.WriteLine(Err.Description)
            Exit Sub

        End Try

        'JVLink終了処理
        lReturnCode = Class1.AxJVLink.JVClose()
        If lReturnCode <> 0 Then
            MsgBox("JVCloseエラー：" & lReturnCode)
        End If

    End Sub

    Private Sub tmrDownload_Tick(sender As Object, e As EventArgs) Handles tmrDownload.Tick
        Dim lReturnCode As Long                ''JVLink返値

        'JVLinkダウンロード進捗率
        lReturnCode = Class1.AxJVLink.JVStatus       ''ダウンロード済のファイル数を返す

        'エラー判定
        If lReturnCode < 0 Then
            'エラー
            MsgBox("JVStatusエラー:" & lReturnCode)
            'タイマー停止
            tmrDownload.Enabled = False

            'JVLink終了処理
            lReturnCode = Class1.AxJVLink.JVClose()
            If lReturnCode <> 0 Then
                MsgBox("JVClseエラー：" & lReturnCode)
            End If
        ElseIf lReturnCode < lDownloadCount Then
            'ダウンロード中
            'プログレス表示
            prgDownload.Value = lReturnCode
        ElseIf lReturnCode = lDownloadCount Then
            'ダウンロード完了
            'タイマー停止
            tmrDownload.Enabled = False
            'プログレス表示
            prgDownload.Value = lReturnCode
        End If

    End Sub
End Class
